package ga.core.individual;

/**
 * Interface that adds aging function to an individual.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IAge {

  /**
   * Getter for the age.
   * 
   * @return The age.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public int getAge();

  /**
   * Increments the age.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void incAge();

  /**
   * Determines if the individual is too old and should die.
   * 
   * @return Old
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public boolean isOld();

  /**
   * Getter for the normalized age (in [0;1]).
   * 
   * @return The normalized age.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public float getAgeNormalized();

  /**
   * Setter for the maximum age.
   * 
   * @param maxAge
   *          The maximum age
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void setMaxAge(int maxAge);
}
